#ifndef ZMODELER_TEXTURESSET_INCLUDED
#define ZMODELER_TEXTURESSET_INCLUDED

///////////////////////////////////////////////////////////////
//  TEXTURES storage class: Adding deleting, IDirect3DTexture
///////////////////////////////////////////////////////////////
#define TEX_NAMEPATHMATCH_NOCASE    0x0001  //toLower convert
#define TEX_NAMEPATHMATCH_NAMEONLY  0x0002
#define TEX_NAMEPATHMATCH_PATHONLY  0x0004

#define TEX_USESPECIFIEDPATH        0x00000010
#define TEX_RELOADEXISTEN           0x00000020
#define TEX_CONFIRMRELOAD           0x00000040


class AFX_EXT_CLASS tTextureSet
{
public:
  tTextureSet();
  CString     *NameSet;
  CString     *PathSet;
  long        TexturesAmount;
  long        PathsAmount;

  long        AddTexture(char* pathname, DWORD nLoadFlags);
  long        AddTexture(sTextureDescriptor* pDescriptor);

  long        InsertTexture(char* pathname, long pos);
  long        AddPath(char* path);


  void        CleanUpAllTextures();
  void        DeleteAllTextures();  //delete names, but not pathes
  void        DeleteAllPaths();

  void        SafeDeleteAllTextures();
  void        DeleteTexture(long index);

  void        RestoreTextures(LPDIRECT3DDEVICE7 pd3dDevice);

  LPDIRECTDRAWSURFACE7  GetTexture(long index);

  ~tTextureSet();

  char*       GetName(long index);
  char*       GetPaths(long index);
  long        GetNameMatch(char* name, UINT match);//returns index of a texture or -1
  long        GetPathMatch(char* path, UINT match);//returns index of a path or -1 if no
private:
  long        LoadCustomTexture(char* pName);
};


//-------------------------------
// Resource-based textures:
typedef struct tTextureBlock
{
  DWORD                 m_dwWidth;
  DWORD                 m_dwHeight;
  DWORD*                m_pRGBAData;
  LPDIRECTDRAWSURFACE7  surface;
  AFX_EXT_CLASS         tTextureBlock();
  AFX_EXT_CLASS         ~tTextureBlock();
}*ptTextureBlock, **pptTextureBlock;


AFX_EXT_CLASS HRESULT RestoreTexture(tTextureBlock* pBlock, LPDIRECT3DDEVICE7 pd3dDevice);
AFX_EXT_CLASS void CreateTextureFromResource(tProcParams* params, tTextureBlock* pBlock, DWORD dwID);

#endif /* ZMODELER_TEXTRESSET_INCLUDED */
